<?php
/**
 * OTIMIZAÇÃO TOTAL - REMOÇÃO DE REQUISIÇÕES INDIVIDUAIS (TMDB/INFO)
 */
ob_start(); 

ini_set('memory_limit', '512M'); 
error_reporting(0); 
ini_set('display_errors', 0); 

include_once "session.php";
include_once "config.php";
include_once "header.php";

function getApiDataWithCache($apiUrl, $cacheKey, $expirationTime = 600) {
    if (session_status() === PHP_SESSION_NONE) { session_start(); }
    
    if (isset($_SESSION[$cacheKey]) && is_array($_SESSION[$cacheKey])) {
        if ((time() - $_SESSION[$cacheKey]['time']) < $expirationTime) {
            return $_SESSION[$cacheKey]['data'] ?? [];
        }
    }

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 8, 
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_ENCODING => "gzip", 
        CURLOPT_USERAGENT => 'IPTV_Core_Shield'
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode !== 200 || !$response) return [];

    $data = json_decode($response, true);
    if (!is_array($data)) return [];

    $cachedData = (count($data) > 1000) ? array_slice($data, 0, 1000) : $data;

    $_SESSION[$cacheKey] = [
        'time' => time(),
        'data' => $cachedData
    ];

    return $cachedData;
}

$get_dns = isset($get_dns) ? rtrim($get_dns, '/') : '';
$username = isset($username) ? urlencode($username) : '';
$password = isset($password) ? urlencode($password) : '';

// Categorias
$apiUrlCat = "$get_dns/player_api.php?username=$username&password=$password&action=get_vod_categories";
$movie_categories = getApiDataWithCache($apiUrlCat, 'movie_categories_cache', 3600);

// Filmes (VOD)
$apiUrlVod = "$get_dns/player_api.php?username=$username&password=$password&action=get_vod_streams";
$channel_api = getApiDataWithCache($apiUrlVod, 'vod_streams_cache', 1200);
if (!empty($channel_api)) { shuffle($channel_api); }

// Séries
$seriesApiUrl = "$get_dns/player_api.php?username=$username&password=$password&action=get_series";
$channel_api1 = getApiDataWithCache($seriesApiUrl, 'series_cache', 1200);
if (!empty($channel_api1)) { shuffle($channel_api1); }

gc_collect_cycles(); 
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <title>WEB PLAYER</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap" rel="stylesheet" />
    <style>
        :root { 
            --primary: #ff003c; 
            --bg-dark: #0a0a0c; 
            --glass: rgba(255, 255, 255, 0.05); 
            --glass-border: rgba(255, 255, 255, 0.1); 
        }
        
        body { margin: 0; background: var(--bg-dark); color: #fff; font-family: 'Montserrat', sans-serif; overflow-x: hidden; }

        /* --- CONFIGURAÇÃO DO MENU MOBILE --- */
        .mobile-nav { display: none; } /* Escondido no PC */

        @media (max-width: 768px) {
            body { padding-bottom: 90px; } /* Espaço para não cobrir o conteúdo */
            
            .mobile-nav { 
                display: flex; 
                position: fixed; 
                bottom: 15px; 
                left: 50%; 
                transform: translateX(-50%); 
                width: 95%; 
                max-width: 500px; 
                height: 70px; 
                background: rgba(15, 15, 20, 0.85); 
                backdrop-filter: blur(15px); 
                -webkit-backdrop-filter: blur(15px); 
                justify-content: space-around; 
                align-items: center; 
                border-radius: 25px; 
                border: 1px solid rgba(255, 255, 255, 0.1); 
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5); 
                z-index: 99999; 
                padding: 0 10px;
            }

            .nav-item { 
                text-decoration: none; 
                display: flex; 
                flex-direction: column; 
                align-items: center; 
                justify-content: center; 
                color: rgba(255, 255, 255, 0.5); 
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); 
                position: relative; 
                flex: 1; 
            }

            .nav-item i { font-size: 1.2rem; margin-bottom: 4px; }
            .nav-item span { font-size: 9px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; }

            /* Ativo e Hover */
            .nav-item:hover, .nav-item.active { color: var(--primary); transform: translateY(-5px); }
            
            .nav-item.active::before {
                content: '';
                position: absolute;
                top: -12px;
                width: 20px;
                height: 4px;
                background: var(--primary);
                border-radius: 0 0 10px 10px;
                box-shadow: 0 5px 15px rgba(255, 0, 60, 0.4);
            }

            /* Efeito especial Fluxo */
            .nav-item.pulse i { color: #00f2ff; animation: meteor-glow 2s infinite; }

            .grid-container { grid-template-columns: repeat(3, 1fr) !important; gap: 8px !important; padding: 10px !important; }
        }

        @keyframes meteor-glow {
            0% { filter: drop-shadow(0 0 2px rgba(0, 242, 255, 0.5)); }
            50% { filter: drop-shadow(0 0 8px rgba(0, 242, 255, 0.9)); }
            100% { filter: drop-shadow(0 0 2px rgba(0, 242, 255, 0.5)); }
        }

        /* --- ESTILOS DO CONTEÚDO --- */
        .section-header { display: flex; justify-content: space-between; align-items: center; padding: 0 20px; margin-top: 35px; }
        .section-title { font-size: 1.1rem; font-weight: 800; border-left: 4px solid var(--primary); padding-left: 12px; }
        
        .grid-container { display: grid; grid-template-columns: repeat(auto-fill, minmax(160px, 1fr)); gap: 15px; padding: 20px; }
        .grid-item { background: var(--glass); border-radius: 10px; overflow: hidden; border: 1px solid var(--glass-border); transition: 0.3s; text-decoration: none; color: inherit; }
        .grid-item:hover { transform: translateY(-5px); border-color: var(--primary); }
        .grid-item img { width: 100%; aspect-ratio: 2/3; object-fit: cover; }
        .grid-item p { font-size: 0.8rem; padding: 10px; text-align: center; margin: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }

        @media (max-width: 360px) {
            .nav-item span { display: none; }
            .nav-item i { font-size: 1.4rem; }
        }
    </style>
</head>
<body>

<div class="section-header">
    <h2 class="section-title">FILMES RECOMENDADOS</h2>
    <a href="moviesondemand.php" style="color: var(--primary); text-decoration: none; font-size: 0.75rem; font-weight: 800; border: 1px solid var(--primary); padding: 4px 12px; border-radius: 20px;">VER TUDO</a>
</div>
<div class="grid-container">
    <?php if(!empty($channel_api)): $c=0; foreach ($channel_api as $value): if($c++ >= 12) break; ?>
        <a href="Movie_description?id=<?= $value["stream_id"] ?>" class="grid-item">
            <img src="<?= $value["stream_icon"] ?: "img/sTREAMING (3) (1).png" ?>" alt="Movie" loading="lazy" />
            <p><?= htmlspecialchars($value["name"] ?? 'Sem título') ?></p>
        </a>
    <?php endforeach; endif; ?>
</div>

<div class="section-header">
    <h2 class="section-title">SÉRIES EM ALTA</h2>
    <a href="seriesondemand.php" style="color: var(--primary); text-decoration: none; font-size: 0.75rem; font-weight: 800; border: 1px solid var(--primary); padding: 4px 12px; border-radius: 20px;">VER TUDO</a>
</div>
<div class="grid-container">
    <?php if(!empty($channel_api1)): $c=0; foreach ($channel_api1 as $value): if($c++ >= 12) break; ?>
        <a href="seriesvideo?id=<?= $value["series_id"] ?>" class="grid-item">
            <img src="<?= $value["cover"] ?: "img/sTREAMING (3) (1).png" ?>" alt="Serie" loading="lazy" />
            <p><?= htmlspecialchars($value["name"] ?? 'Sem título') ?></p>
        </a>
    <?php endforeach; endif; ?>
</div>

<nav class="mobile-nav">
    <a href="homex.php" class="nav-item active"><i class="fas fa-th-large"></i><span>INICIO</span></a>
    <a href="tvguide.php" class="nav-item"><i class="fas fa-satellite-dish"></i><span>CANAIS</span></a>
    <a href="moviesondemand.php" class="nav-item"><i class="fas fa-play-circle"></i><span>FILMES</span></a>
    <a href="seriesondemand.php" class="nav-item"><i class="fas fa-clapperboard"></i><span>SÉRIES</span></a>
    <a href="myaccount.php" class="nav-item"><i class="fas fa-user-circle"></i><span>CONTA</span></a>
    <a href="settings.php" class="nav-item pulse"><i class="fas fa-bolt"></i><span>FLUXO</span></a>
    <a href="logout.php" class="nav-item"><i class="fas fa-power-off"></i><span>SAIR</span></a>
</nav>

</body>
</html>
<?php 
ob_end_flush(); 
?>